<?php
include "shared-functions.php";
include "../company-details.php";

$webhookSecret = "5rf9x8b7p4bgov3yo74vc";
$rawPayload = file_get_contents("php://input");
$headers = function_exists("getallheaders")
    ? getallheaders()
    : array_change_key_case(apache_request_headers(), CASE_LOWER);
$payload = json_decode($rawPayload, true);
$event_type = strtolower($payload["eventType"] ?? "");

$conn->beginTransaction();

try {
    if (
        strpos($event_type, "wallet.load") !== false ||
        strpos($event_type, "transaction.payout") !== false
    ) {
        processTransaction($conn, $payload, $event_type);
    } else {
        handleOtherEvent($payload);
    }

    $conn->commit();
} catch (Exception $e) {
    $conn->rollBack();
    logTransaction("Database error: " . $e->getMessage(), "error");
    header("HTTP/1.1 500 Internal Server Error");
    exit("Server Error: Unable to process transaction");
}

logTransaction(
    "Webhook Data: " .
        print_r(
            [
                "Raw Payload" => $rawPayload,
                "Decoded Payload" => $payload,
                "Headers" => $headers,
                "Event Type" => $event_type,
            ],
            true
        )
);

http_response_code(200);
exit("Success");

function processTransaction($conn, $payload, $event_type)
{
    global $conn;

    $status = strtolower($payload["status"] ?? "unknown");
    $transaction_id = $payload["transactionId"] ?? null;
    $transaction_ref = $payload["transactionRef"] ?? null;
    $currency = $payload["currency"] ?? null;
    $amount = $payload["amount"] ?? 0;
    $is_wallet_load = strpos($event_type, "wallet.load") !== false;
    $is_payout = strpos($event_type, "transaction.payout") !== false;

    // Update transaction status
    $stmt = $conn->prepare(
        "UPDATE transactions SET status = ?, transaction_id = ? WHERE transaction_ref = ?"
    );
    $stmt->execute([$status, $transaction_id, $transaction_ref]);

    // Fetch user UUID and amount
    $stmt = $conn->prepare(
        "SELECT uuid, amount, service_fee FROM transactions WHERE transaction_ref = ?"
    );
    $stmt->execute([$transaction_ref]);
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($result) {
        $uuid = $result["uuid"];
        $amount = $result["amount"];
        $service_fee = 0.0;

        // If its a successful toput
        if ($is_wallet_load && $status === "successful") {
            updateWalletAmount($conn, $amount, $uuid, $currency, true);
            insertEarnings(
                $conn,
                $uuid,
                $currency,
                $transaction_ref,
                $service_fee,
                "deposit",
                "completed",
                true
            );
            updateCommission($conn, $service_fee, $currency, true);

            // If its a failed payout
        } elseif ($is_payout && $status !== "successful") {
            updateWalletAmount($conn, $amount, $uuid, $currency, false);
            insertEarnings(
                $conn,
                $uuid,
                $currency,
                $transaction_ref,
                $service_fee,
                "deposit",
                "completed",
                false
            );
            updateCommission($conn, $service_fee, $currency, false);
        }

        insertAuditLog(
            $conn,
            $uuid,
            "Transaction status updated: $status",
            $_SERVER["HTTP_USER_AGENT"] ?? "Unknown",
            $_SERVER["REMOTE_ADDR"] ?? "Unknown"
        );
    } else {
        logTransaction(
            "No matching transaction found for ref: $transaction_ref",
            "error"
        );
    }
}

function handleOtherEvent($payload)
{
    logTransaction("Unhandled Event: " . json_encode($payload), "info");
}
?>
